%------------------------------------------------------------------------------
% File     : SYO067^4.003 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Logic Calculi (Intuitionistic logic)
% Problem  : ILTP Problem SYJ203+1.003
% Version  : [Goe33] axioms.
% English  :

% Refs     : [Goe33] Goedel (1933), An Interpretation of the Intuitionistic
%          : [Gol06] Goldblatt (2006), Mathematical Modal Logic: A View of
%          : [ROK06] Raths et al. (2006), The ILTP Problem Library for Intu
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
%          : [BP10]  Benzmueller & Paulson (2009), Exploring Properties of
% Source   : [Ben09]
% Names    : SYJ203+1.003 [ROK06]

% Status   : Theorem
% Rating   : 1.00 v4.0.0
% Syntax   : Number of formulae    :   47 (   0 unit;  24 type;  19 defn)
%            Number of atoms       :  144 (  19 equality;  48 variable)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   86 (   3   ~;   1   |;   2   &;  78   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   99 (  99   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   27 (  24   :;   0   =)
%            Number of variables   :   40 (   1 sgn;   7   !;   2   ?;  31   ^)
%                                         (  40   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is an ILTP problem embedded in TH0
%------------------------------------------------------------------------------
include('Axioms/LCL010^0.ax').
%------------------------------------------------------------------------------
thf(f_type,type,(
    f: $i > $o )).

thf(p1_type,type,(
    p1: $i > $o )).

thf(p2_type,type,(
    p2: $i > $o )).

thf(p3_type,type,(
    p3: $i > $o )).

thf(axiom1,axiom,
    ( ivalid @ ( iimplies @ ( ior @ ( iand @ ( iatom @ p1 ) @ ( iand @ ( iatom @ p2 ) @ ( iatom @ p3 ) ) ) @ ( ior @ ( iimplies @ ( iatom @ p1 ) @ ( iatom @ f ) ) @ ( ior @ ( iimplies @ ( iatom @ p2 ) @ ( iatom @ f ) ) @ ( iimplies @ ( iatom @ p3 ) @ ( iatom @ f ) ) ) ) ) @ ( iatom @ f ) ) )).

thf(con,conjecture,
    ( ivalid @ ( iatom @ f ) )).

%------------------------------------------------------------------------------
